/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xobj;

import java.util.Vector;
import uk.co.demon.obelisk.xobj.Byte;
import uk.co.demon.obelisk.xobj.Code;
import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Hex;
import uk.co.demon.obelisk.xobj.Long;
import uk.co.demon.obelisk.xobj.Module;
import uk.co.demon.obelisk.xobj.Part;
import uk.co.demon.obelisk.xobj.Value;
import uk.co.demon.obelisk.xobj.Word;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section {
    private final Module module;
    private final String name;
    private boolean relative;
    private long start;
    private int size;
    private Vector<Part> parts = new Vector();

    public Section(Module module, String name) {
        this.module = module;
        this.name = name;
        this.relative = true;
        this.clear();
    }

    public Section(Module module, String name, long start) {
        this.module = module;
        this.name = name;
        this.start = start;
        this.relative = false;
        this.clear();
    }

    public String getName() {
        return this.name;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public boolean isAbsolute() {
        return !this.relative;
    }

    public long getStart() {
        return this.start;
    }

    public int getSize() {
        return this.size;
    }

    public Value getOrigin() {
        return new Value(this.relative ? this : null, this.start + (long)this.size);
    }

    public Section setOrigin(long origin) {
        return this.module.findSection(this.name, origin);
    }

    public void clear() {
        this.size = 0;
        this.parts.clear();
    }

    public void addByte(Expr expr) {
        if (expr.isAbsolute()) {
            this.addByte(expr.resolve(null, null));
        } else {
            this.parts.add(new Byte(expr));
            ++this.size;
        }
    }

    public void addWord(Expr expr) {
        if (expr.isAbsolute()) {
            this.addWord(expr.resolve(null, null));
        } else {
            this.parts.add(new Word(expr));
            this.size += 2;
        }
    }

    public void addLong(Expr expr) {
        if (expr.isAbsolute()) {
            this.addLong(expr.resolve(null, null));
        } else {
            this.parts.add(new Long(expr));
            this.size += 4;
        }
    }

    public void addByte(long value) {
        if (this.parts.isEmpty() || !(this.parts.lastElement() instanceof Code)) {
            this.parts.add(new Code(this.module));
        }
        ((Code)this.parts.lastElement()).addByte(value);
        ++this.size;
    }

    public void addWord(long value) {
        int byteSize = this.module.getByteSize();
        long byteMask = this.module.getByteMask();
        if (this.parts.isEmpty() || !(this.parts.lastElement() instanceof Code)) {
            this.parts.add(new Code(this.module));
        }
        if (this.module.isBigEndian()) {
            ((Code)this.parts.lastElement()).addByte(value >> 1 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 0 * byteSize & byteMask);
        } else {
            ((Code)this.parts.lastElement()).addByte(value >> 0 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 1 * byteSize & byteMask);
        }
        this.size += 2;
    }

    public void addLong(long value) {
        int byteSize = this.module.getByteSize();
        long byteMask = this.module.getByteMask();
        if (this.parts.isEmpty() || !(this.parts.lastElement() instanceof Code)) {
            this.parts.add(new Code(this.module));
        }
        if (this.module.isBigEndian()) {
            ((Code)this.parts.lastElement()).addByte(value >> 3 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 2 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 1 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 0 * byteSize & byteMask);
        } else {
            ((Code)this.parts.lastElement()).addByte(value >> 0 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 1 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 2 * byteSize & byteMask);
            ((Code)this.parts.lastElement()).addByte(value >> 3 * byteSize & byteMask);
        }
        this.size += 4;
    }

    public String toString() {
        if (this.parts.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<section name='" + this.name + "'");
            if (!this.relative) {
                buffer.append(" addr='" + Hex.toHex(this.start, 8) + "' size='" + this.size + "'");
            }
            buffer.append(">");
            int index = 0;
            while (index < this.parts.size()) {
                buffer.append(this.parts.elementAt(index).toString());
                ++index;
            }
            buffer.append("</section>");
            return buffer.toString();
        }
        return "";
    }

    public Vector<Part> getParts() {
        return this.parts;
    }

    protected void setStart(int start) {
        this.start = start;
        this.relative = false;
    }

    protected void setSize(int size) {
        this.size = size;
    }
}

